/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import java.util.ArrayList;
import java.util.List;
import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshair.component.CrosshairVariant;
import mod.crend.dynamiccrosshair.component.ModifierHit;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyledPart;
import mod.crend.dynamiccrosshairapi.crosshair.Crosshair;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairPart;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;

public class CrosshairComponent {
    public static final CrosshairComponent FORCE_CROSSHAIR = new CrosshairComponent(new Crosshair(InteractionType.FORCE_REGULAR_CROSSHAIR));
    Crosshair crosshair;
    CrosshairStyle primaryStyle = null;
    CrosshairStyle secondaryStyle = null;
    CrosshairStyle hitModifier = null;
    List<CrosshairStyledPart> stylesWithBlend = new ArrayList<CrosshairStyledPart>();
    List<CrosshairStyledPart> stylesWithoutBlend = new ArrayList<CrosshairStyledPart>();

    public CrosshairComponent(Crosshair crosshair) {
        this.crosshair = crosshair;
        CrosshairVariant primary = CrosshairVariant.Regular;
        CrosshairVariant secondary = CrosshairVariant.NONE;
        ModifierHit modifierHit = ModifierHit.NONE;
        switch (crosshair.primaryInteraction()) {
            case TARGET_BLOCK: {
                primary = CrosshairVariant.OnBlock;
                break;
            }
            case TARGET_ENTITY: {
                primary = CrosshairVariant.OnEntity;
                break;
            }
            case MELEE_WEAPON: {
                primary = CrosshairVariant.HoldingMeleeWeapon;
                break;
            }
            case TOOL: {
                primary = CrosshairVariant.HoldingTool;
                break;
            }
            case CORRECT_TOOL: {
                primary = CrosshairVariant.HoldingTool;
                modifierHit = ModifierHit.CORRECT_TOOL;
                break;
            }
            case INCORRECT_TOOL: {
                primary = CrosshairVariant.HoldingTool;
                modifierHit = ModifierHit.INCORRECT_TOOL;
            }
        }
        if (crosshair.primaryInteraction() != InteractionType.FORCE_REGULAR_CROSSHAIR) {
            switch (crosshair.secondaryInteraction()) {
                case USE_ITEM: 
                case EQUIP_ITEM: 
                case CONSUME_ITEM: 
                case CHARGE_ITEM: 
                case USE_ITEM_ON_BLOCK: 
                case PLACE_ITEM_ON_BLOCK: 
                case FILL_ITEM_FROM_BLOCK: 
                case FILL_BLOCK_FROM_ITEM: 
                case USE_BLOCK: 
                case USE_ITEM_ON_ENTITY: 
                case PICK_UP_BLOCK: 
                case PICK_UP_ENTITY: 
                case PLACE_ITEM_ON_ENTITY: 
                case FILL_ITEM_FROM_ENTITY: 
                case FILL_ENTITY_FROM_ITEM: {
                    secondary = CrosshairVariant.HoldingUsableItem;
                    break;
                }
                case SPYGLASS: {
                    if (DynamicCrosshairMod.config.dynamicCrosshairForceHoldingSpyglass()) {
                        primary = CrosshairVariant.Regular;
                        break;
                    }
                    secondary = CrosshairVariant.HoldingUsableItem;
                    break;
                }
                case THROW_ITEM: {
                    secondary = CrosshairVariant.HoldingThrowable;
                    break;
                }
                case PLACE_BLOCK: 
                case PLACE_ENTITY: {
                    secondary = CrosshairVariant.HoldingBlock;
                    break;
                }
                case INTERACT_WITH_BLOCK: 
                case TAKE_ITEM_FROM_BLOCK: 
                case MOUNT_BLOCK: 
                case INTERACT_WITH_ENTITY: 
                case TAKE_ITEM_FROM_ENTITY: 
                case MOUNT_ENTITY: 
                case PICK_UP_ITEM: {
                    secondary = CrosshairVariant.CanInteract;
                    break;
                }
                case RANGED_WEAPON_CHARGING: {
                    primary = CrosshairVariant.Regular;
                    break;
                }
                case RANGED_WEAPON: 
                case RANGED_WEAPON_CHARGED: {
                    secondary = CrosshairVariant.HoldingRangedWeapon;
                    break;
                }
                case USABLE_TOOL: {
                    primary = CrosshairVariant.HoldingTool;
                    secondary = CrosshairVariant.HoldingUsableItem;
                    break;
                }
                case SHIELD: {
                    secondary = CrosshairVariant.HoldingShield;
                    break;
                }
                case FORCE_REGULAR_CROSSHAIR: {
                    modifierHit = ModifierHit.NONE;
                }
            }
        }
        this.primaryStyle = this.getCrosshairStyle(primary);
        this.secondaryStyle = this.getCrosshairStyle(secondary);
        if (DynamicCrosshairMod.config.dynamicCrosshairDisplayCorrectTool()) {
            switch (modifierHit) {
                case CORRECT_TOOL: {
                    this.hitModifier = DynamicCrosshairMod.config.getCrosshairModifierCorrectTool();
                    break;
                }
                case INCORRECT_TOOL: {
                    this.hitModifier = DynamicCrosshairMod.config.getCrosshairModifierIncorrectTool();
                }
            }
        }
        if (this.primaryStyle != null) {
            if (this.secondaryStyle != null && !this.secondaryStyle.coalesce()) {
                this.primaryStyle = null;
            } else if (!this.primaryStyle.coalesce()) {
                this.secondaryStyle = null;
            }
        }
        if (this.primaryStyle != null) {
            if (this.primaryStyle.enableBlend()) {
                this.stylesWithBlend.add(new CrosshairStyledPart(CrosshairPart.PRIMARY, this.primaryStyle));
            } else {
                this.stylesWithoutBlend.add(new CrosshairStyledPart(CrosshairPart.PRIMARY, this.primaryStyle));
            }
        } else if (this.secondaryStyle == null) {
            CrosshairStyle crosshairStyle = CrosshairComponent.FORCE_CROSSHAIR.primaryStyle;
            if (crosshairStyle.enableBlend()) {
                this.stylesWithBlend.add(new CrosshairStyledPart(CrosshairPart.PRIMARY, this.primaryStyle));
            } else {
                this.stylesWithoutBlend.add(new CrosshairStyledPart(CrosshairPart.PRIMARY, this.primaryStyle));
            }
        }
        if (this.secondaryStyle != null) {
            if (this.secondaryStyle.enableBlend()) {
                this.stylesWithBlend.add(new CrosshairStyledPart(CrosshairPart.SECONDARY, this.secondaryStyle));
            } else {
                this.stylesWithoutBlend.add(new CrosshairStyledPart(CrosshairPart.SECONDARY, this.secondaryStyle));
            }
        }
        for (CrosshairStyle modifier : this.getModifiers()) {
            if (modifier.enableBlend()) {
                this.stylesWithBlend.add(new CrosshairStyledPart(CrosshairPart.MODIFIER, modifier));
                continue;
            }
            this.stylesWithoutBlend.add(new CrosshairStyledPart(CrosshairPart.MODIFIER, modifier));
        }
    }

    private CrosshairStyle getCrosshairStyle(CrosshairVariant variant) {
        return switch (variant) {
            default -> throw new MatchException(null, null);
            case CrosshairVariant.NONE -> null;
            case CrosshairVariant.Regular -> DynamicCrosshairMod.config.getCrosshairStyleRegular();
            case CrosshairVariant.OnBlock -> DynamicCrosshairMod.config.getCrosshairStyleOnBlock();
            case CrosshairVariant.OnEntity -> DynamicCrosshairMod.config.getCrosshairStyleOnEntity();
            case CrosshairVariant.HoldingBlock -> DynamicCrosshairMod.config.getCrosshairStyleHoldingBlock();
            case CrosshairVariant.HoldingTool -> DynamicCrosshairMod.config.getCrosshairStyleHoldingTool();
            case CrosshairVariant.HoldingMeleeWeapon -> DynamicCrosshairMod.config.getCrosshairStyleHoldingMeleeWeapon();
            case CrosshairVariant.HoldingRangedWeapon -> DynamicCrosshairMod.config.getCrosshairStyleHoldingRangedWeapon();
            case CrosshairVariant.HoldingThrowable -> DynamicCrosshairMod.config.getCrosshairStyleHoldingThrowable();
            case CrosshairVariant.HoldingUsableItem -> DynamicCrosshairMod.config.getCrosshairStyleUsableItem();
            case CrosshairVariant.HoldingShield -> DynamicCrosshairMod.config.getCrosshairStyleShield();
            case CrosshairVariant.CanInteract -> DynamicCrosshairMod.config.getCrosshairStyleInteractable();
        };
    }

    public List<CrosshairStyle> getModifiers() {
        if (this.hitModifier == null) {
            return List.of();
        }
        return List.of(this.hitModifier);
    }

    public Crosshair getCrosshair() {
        return this.crosshair;
    }

    public List<CrosshairStyledPart> getStylesWithBlend() {
        return this.stylesWithBlend;
    }

    public List<CrosshairStyledPart> getStylesWithoutBlend() {
        return this.stylesWithoutBlend;
    }
}

